<?php if ( ! defined('WOODMART_THEME_DIR')) exit('No direct script access allowed');

/**
 * ------------------------------------------------------------------------------------------------
 * Main loop
 * ------------------------------------------------------------------------------------------------
 */

if( ! function_exists( 'woodmart_main_loop' ) ) {

	add_action( 'woodmart_main_loop', 'woodmart_main_loop' );

	function woodmart_main_loop() {
        global $paged, $wp_query;

        $max_page = $wp_query->max_num_pages;

        $pagination = woodmart_get_opt( 'blog_pagination' );

		# fix bug with wrong escaped url generated by next_posts() call
		if( is_search() ) {
			$pagination = 'pagination';
		}
		
        $is_ajax = woodmart_is_woo_ajax();

        if ( !$paged )
                $paged = 1;

		?>

			<?php if ( have_posts() ) : ?>

				<?php if ( ! $is_ajax ): ?>

					<?php if ( is_tag() && tag_description() ) : // Show an optional tag description ?>
						<div class="archive-meta"><?php echo tag_description(); ?></div>
					<?php endif; ?>

					<?php if ( is_category() && category_description() ) : // Show an optional category description ?>
						<div class="archive-meta"><?php echo category_description(); ?></div>
					<?php endif; ?>

					<?php if ( is_author() && get_the_author_meta( 'description' ) ): ?>
						<?php get_template_part( 'author-bio' ); ?>
					<?php endif ?>

				<?php endif ?>

				<?php if ( ! $is_ajax ): ?>
					<div class="woodmart-blog-holder <?php if( woodmart_get_opt('blog_design') == 'masonry' ): ?>masonry-container<?php endif ?> blog-pagination-<?php echo esc_attr( $pagination ); ?>" data-paged="1" data-source="main_loop">
				<?php endif ?>

					<?php if ( $is_ajax ) ob_start(); ?>
				
					<?php while ( have_posts() ) : the_post(); ?>
						<?php get_template_part( 'content', get_post_format() ); ?>
					<?php endwhile; ?>

					<?php if ( $is_ajax ) $output = ob_get_clean(); ?>

				<?php if ( ! $is_ajax ): ?>
					</div>
					<?php if ( $pagination == 'infinit' || $pagination == 'load_more' ): ?>
						<div class="blog-footer">
							<?php if( get_next_posts_link() ) :?>
								<a href="<?php echo add_query_arg( 'woo_ajax', '1', next_posts( $max_page, false ) ); ?>" class="btn woodmart-load-more woodmart-blog-load-more load-on-<?php echo ($pagination == 'load_more') ? 'click' : 'scroll'; ?>"><span class="load-more-label"><?php esc_html_e('Load more posts', 'woodmart'); ?></span><span class="load-more-loading"><?php esc_html_e('Loading...', 'woodmart'); ?></span></a>
							<?php endif; ?>
						</div>
					<?php else: ?>
						<?php woodmart_paging_nav(); ?>
					<?php endif ?>
				<?php endif ?>


			<?php else : ?>
				<?php get_template_part( 'content', 'none' ); ?>
			<?php endif; ?>

		<?php

	    if( $is_ajax ) {
	    	$output =  array(
	    		'items' => $output,
	    		'status' => ( $max_page > $paged ) ? 'have-posts' : 'no-more-posts',
	    		'nextPage' => add_query_arg( 'woo_ajax', '1', next_posts( $max_page, false ) )
	    	);

	    	echo json_encode( $output );
	    }
	}
}

/**
 * ------------------------------------------------------------------------------------------------
 * Footer woodmart extra action
 * ------------------------------------------------------------------------------------------------
 */

if( ! function_exists( 'woodmart_extra_footer_action' ) ) {
	function woodmart_extra_footer_action() {
		if ( woodmart_needs_footer() && !woodmart_is_compare_iframe() ) do_action( 'woodmart_after_footer' );
	}

	add_action( 'wp_footer', 'woodmart_extra_footer_action', 500);
}


/**
 * ------------------------------------------------------------------------------------------------
 * Read more button
 * ------------------------------------------------------------------------------------------------
 */

if( ! function_exists( 'woodmart_modify_read_more_link' ) ) {
	function woodmart_modify_read_more_link() {
		return '</p><p class="read-more-section">' . woodmart_read_more_tag();
	}
}

add_filter( 'the_content_more_link', 'woodmart_modify_read_more_link' );



if( ! function_exists( 'woodmart_read_more_tag' ) ) {
	function woodmart_read_more_tag() {
		return '<a class="btn-read-more more-link" href="' . get_permalink() . '">' . esc_html__('Continue reading', 'woodmart') . '</a>';
	}
}


/**
 * ------------------------------------------------------------------------------------------------
 * Get post image
 * ------------------------------------------------------------------------------------------------
 */

if ( ! function_exists( 'woodmart_get_post_thumbnail' ) ) {
	function woodmart_get_post_thumbnail( $size = 'medium', $attach_id = false ) {
		global $post, $woodmart_loop;

		if ( has_post_thumbnail() ) {

			if( function_exists( 'wpb_getImageBySize' ) ) {
				if( ! $attach_id ) $attach_id = get_post_thumbnail_id();

				if( ! empty( $woodmart_loop['img_size'] ) ) $size = $woodmart_loop['img_size'];
				
				$img = wpb_getImageBySize( array( 'attach_id' => $attach_id, 'thumb_size' => $size, 'class' => 'attachment-large wp-post-image' ) );
				$img = $img['thumbnail'];

			} else {
				$img = get_the_post_thumbnail( $post->ID, $size );
			}

			return $img;
		}
	}
}

/**
 * ------------------------------------------------------------------------------------------------
 * Get post content
 * ------------------------------------------------------------------------------------------------
 */


if( ! function_exists( 'woodmart_get_content' ) ) {
	function woodmart_get_content( $btn = true, $force_full = false ) {
		global $post;

		$type = woodmart_get_opt( 'blog_excerpt' );

		if( $force_full ) {
			$type = 'full';
		}

		if( $type == 'full' ) {
			woodmart_get_full_content( $btn );
		} elseif( $type == 'excerpt' ) {

	        if ( ! empty( $post->post_excerpt ) ) {
	            the_excerpt();
	        } else {
		        $excerpt_length = apply_filters( 'woodmart_get_excerpt_length', woodmart_get_opt( 'blog_excerpt_length' ) );
		        echo woodmart_excerpt_from_content( $post->post_content, $excerpt_length );
	        }

	        if( $btn ) {
	        	echo '<p class="read-more-section">' . woodmart_read_more_tag() . '</p>';
	        }

		}

	}
}

if( ! function_exists( 'woodmart_get_full_content' ) ) {
	function woodmart_get_full_content( $btn = false ) {

		$strip_gallery  = apply_filters( 'woodmart_strip_gallery',  true );

		if( get_post_format() == 'gallery' && $strip_gallery ) {

			if( $btn ) {
				$content = woodmart_strip_shortcode_gallery( get_the_content() );                                       
			} else {
				$content = woodmart_strip_shortcode_gallery( get_the_content( '' ) );                                       
			}
			echo str_replace( ']]>', ']]&gt;', apply_filters( 'the_content', $content ) );       
		} else {
			if( $btn ) {
				the_content();                                  
			} else {
				the_content('');                       
			}
		}
	}
}

/**
 * ------------------------------------------------------------------------------------------------
 * Display meta information for a specific post
 * ------------------------------------------------------------------------------------------------
 */
if( ! function_exists( 'woodmart_post_meta' )) {
	function woodmart_post_meta( $atts = array() ) {
		extract(shortcode_atts(array(
			'author'     => 1,
			'author_ava' => 0,
			'date'     => 1,
			'cats'     => 0,
			'tags'     => 0,
			'labels'   => 0,
			'short_labels' => false,
			'edit'     => 1,
			'comments' => 1,
			'limit_cats' => 0
		), $atts));
		?>
			<ul class="entry-meta-list">
				<?php if( get_post_type() === 'post' ): ?>

					<?php // Is sticky ?>

					<?php if( is_sticky() ): ?>
						<li class="meta-featured-post"><?php esc_html_e( 'Featured', 'woodmart' ) ?></li>
					<?php endif; ?>

					<?php // Author ?>
					<?php if ($author == 1): ?>
						<li class="meta-author">
							<?php if ( $labels == 1 && ! $short_labels ): ?>
								<?php esc_html_e('Posted by', 'woodmart'); ?>
							<?php elseif($labels == 1 && $short_labels): ?>
								<?php esc_html_e('By', 'woodmart'); ?>
							<?php endif; ?>
							<?php if ( $author_ava == 1 ): ?>
								<?php echo get_avatar( get_the_author_meta( 'ID' ), 32 ); ?>
							<?php endif; ?>
							<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author"><?php echo get_the_author(); ?></a>
						</li>
					<?php endif ?>
					<?php // Date ?>
					<?php if( $date == 1): ?><li class="meta-date"><?php the_date(); ?></li><?php endif ?>
					<?php // Categories ?>
					<?php if(get_the_category_list( ', ' ) && $cats == 1): ?>
						<li class="meta-categories"><?php echo get_the_category_list( ', ' ); ?></li>
					<?php endif; ?>
					<?php // Tags ?>
					<?php if(get_the_tag_list( '', ', ' ) && $tags == 1): ?>
						<li class="meta-tags"><?php echo get_the_tag_list( '', ', ' ); ?></li>
					<?php endif; ?>
					<?php // Comments ?>
					<?php if( $comments && comments_open() ): ?>
						<li><span class="meta-reply">
							<?php 
								$comment_link_template = '<span class="comments-count">%s</span> <span class="comments-count-label">%s</span>';
							 ?>
							<?php comments_popup_link( 
								sprintf( $comment_link_template, '0', esc_html__( 'comments', 'woodmart' ) ),
								sprintf( $comment_link_template, '1', esc_html__( 'comment', 'woodmart' ) ),
								sprintf( $comment_link_template, '%', esc_html__( 'comments', 'woodmart' ) )
							); ?>
						</span></li>
					<?php endif; ?>
					<?php // Edit link ?>
					<?php if( is_user_logged_in() && $edit == 1 ): ?>
						<!--li><?php edit_post_link( esc_html__( 'Edit', 'woodmart' ), '<span class="edit-link">', '</span>' ); ?></li-->
					<?php endif; ?>
				<?php endif; ?>
			</ul>
		<?php
	}
}

if( ! function_exists( 'woodmart_post_date' ) ) {
	function woodmart_post_date() {
		$has_title = get_the_title() != '';
		$attr = '';
		if( ! $has_title && ! is_single() ) {
			$url = get_the_permalink();
			$attr = ' onclick="window.location=\''. $url .'\';"';
		}
		?>
			<div class="post-date woodmart-post-date"<?php echo ($attr); ?>>
				<span class="post-date-day">
					<?php echo get_the_time('d') ?>
				</span>
				<span class="post-date-month">
					<?php echo get_the_time('M') ?>
				</span>
			</div>
		<?php
	}
}


/**
 * ------------------------------------------------------------------------------------------------
 * Display posts next/prev navigation
 * ------------------------------------------------------------------------------------------------
 */

if( ! function_exists( 'woodmart_posts_navigation' ) ) {
	function woodmart_posts_navigation() {
		?>
			<div class="single-post-navigation">
				 <?php
					    $next_post = get_next_post();
					    $prev_post = get_previous_post();

					    $archive_url = false;

					    if( get_post_type() == 'post' ) {
							$archive_page = get_option( 'page_for_posts' );
							$archive_url = get_permalink( $archive_page );
					    } else if( get_post_type() == 'portfolio' ) {
							$archive_page = woodmart_tpl2id( 'portfolio.php' );
							$archive_url = get_permalink( $archive_page );
					    }
				    ?>
				    
	                <div class="blog-posts-nav-btn prev-btn">
			            <?php if(!empty($prev_post)) : ?>
		                    <div class="posts-nav-inner">
		                    	<a href="<?php echo get_permalink($prev_post->ID); ?>">
			                        <span class="btn-label"><?php esc_html_e('Newer', 'woodmart'); ?></span>
	                           		<span class="post-title"><?php echo get_the_title($prev_post->ID); ?></span>
	                        	</a>
		                    </div>
			            <?php endif; ?>
	                </div>

					<?php if ( $archive_url && 'page' == get_option( 'show_on_front' ) ): ?>
			            <div class="back-to-archive">
			            	<a href="<?php echo esc_url( $archive_url ); ?>"><span class="woodmart-tooltip"><?php esc_html_e('Back to list', 'woodmart'); ?></span></a>
			            </div>
					<?php endif ?>

	                <div class="blog-posts-nav-btn next-btn">
			            <?php if(!empty($next_post)) : ?>
		                    <div class="posts-nav-inner">
		                    	<a href="<?php echo get_permalink($next_post->ID); ?>">
			                        <span class="btn-label"><?php esc_html_e('Older', 'woodmart'); ?></span>
		                        	<span class="post-title"><?php echo get_the_title($next_post->ID); ?></span>
	                        	</a>
		                    </div>
			            <?php endif; ?>
	                </div>
			</div>
		<?php
	}
}


/**
 * ------------------------------------------------------------------------------------------------
 * Display entry meta
 * ------------------------------------------------------------------------------------------------
 */
if( ! function_exists( 'woodmart_entry_meta' ) ) {
	function woodmart_entry_meta() {
		if( apply_filters( 'woodmart_entry_meta' , false ) ) {
			?>
				<footer class="entry-meta">
					<?php if( is_user_logged_in() ): ?>
						<p><?php edit_post_link( esc_html__( 'Edit', 'woodmart' ), '<span class="edit-link">', '</span>' ); ?></p>
					<?php endif; ?>
				</footer><!-- .entry-meta -->
			<?php 
		}
	}
}


/**
 * ------------------------------------------------------------------------------------------------
 * Display navigation to the next/previous set of posts.
 * ------------------------------------------------------------------------------------------------
 */
if( ! function_exists( 'woodmart_paging_nav' ) ) {
	function woodmart_paging_nav() {
		$enable_pagination = apply_filters( 'woodmart_enable_pagination', true );

		if( $enable_pagination ) {
			query_pagination();
			return;
		}
		?>
			
			<ul>
				<?php if( get_previous_posts_link() ) :?>
					<li class="next">
						<?php previous_posts_link( esc_html__( 'Newer Posts &rarr;', 'woodmart' ) ); ?>
					</li>
				<?php endif; ?>
				
				<?php if( get_next_posts_link() ) :?>
					<li class="previous">
						<?php next_posts_link( esc_html__( '&larr; Older Posts', 'woodmart' ) ); ?>
					</li>
				<?php endif; ?>
			</ul>
	
		<?php 
	}
}

if( ! function_exists( 'query_pagination' ) ) {
	function query_pagination($pages = '', $range = 2) {  
	     $showitems = ($range * 2)+1;  

	     global $paged;
	     
	     if(empty($paged)) $paged = 1;

	     if($pages == '')
	     {
	         global $wp_query;
	         $pages = $wp_query->max_num_pages;
	         if(!$pages)
	         {
	             $pages = 1;
	         }
	     }   

	     if(1 != $pages)
	     {
	         echo "<div class='woodmart-pagination'>";
	         if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>&laquo;</a>";
	         if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'>&lsaquo;</a>";

	         for ($i=1; $i <= $pages; $i++)
	         {
	             if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
	             {
	                 echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>";
	             }
	         }

	         if ($paged < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($paged + 1)."'>&rsaquo;</a>";  
	         if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>&raquo;</a>";
	         echo "</div>\n";
	     }
	}
}


// **********************************************************************// 
// ! Add favicon 
// **********************************************************************// 
if( !function_exists( 'woodmart_favicon' ) ) {
	function woodmart_favicon() {
		
		if ( function_exists( 'has_site_icon' ) && has_site_icon() ) return '';

		// Get the favicon.
		$favicon = WOODMART_IMAGES . '/icons/favicon.png';

		// Get the custom touch icon.
		$touch_icon = WOODMART_IMAGES . '/icons/apple-touch-icon-152x152-precomposed.png';

		$fav_uploaded = woodmart_get_opt( 'favicon' );
		if(isset($fav_uploaded['url']) && $fav_uploaded['url'] != '') {
			$favicon = $fav_uploaded['url'];
		}

		$fav_uploaded_retina = woodmart_get_opt( 'favicon_retina' );
		if(isset($fav_uploaded_retina['url']) && $fav_uploaded_retina['url'] != '') {
			$touch_icon = $fav_uploaded_retina['url'];
		}

		?>
			<link rel="shortcut icon" href="<?php echo esc_attr($favicon); ?>">
			<link rel="apple-touch-icon-precomposed" sizes="152x152" href="<?php echo esc_attr($touch_icon); ?>">
		<?php
	}

	add_action( 'wp_head', 'woodmart_favicon' );
}


// **********************************************************************// 
// ! Get logo image
// **********************************************************************// 

if( !function_exists( 'woodmart_get_logo' ) ) {
	function woodmart_get_logo() {
		$logo_src = WOODMART_IMAGES . '/logo.png';

		$logo_uploaded = woodmart_get_opt( 'logo' );
		if(isset($logo_uploaded['url']) && $logo_uploaded['url'] != '') {
			$logo_src = $logo_uploaded['url'];
		}

		?>
			<a href="<?php echo esc_url( home_url('/') ); ?>" rel="home"><img src="<?php echo esc_url( $logo_src ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>"></a>
		<?php 
	}
}


// **********************************************************************// 
// ! Page top part
// **********************************************************************// 

if( ! function_exists( 'woodmart_page_top_part' ) ) {
	function woodmart_page_top_part() {
		?>
		<?php if ( ! woodmart_is_woo_ajax() ): ?>
			<div class="main-page-wrapper">
		<?php elseif( woodmart_is_pjax() ): ?>
			<?php _wp_render_title_tag(); ?>
		<?php endif ?>

		<?php 

			/**
			 * woodmart_after_header hook
			 *
			 * @hooked woodmart_show_page_title - 10
			 */
			do_action( 'woodmart_after_header' ); 
		?>

		<!-- MAIN CONTENT AREA -->
		<?php $main_container_class = woodmart_get_main_container_class(); ?>
		<div class="<?php echo esc_attr( $main_container_class ); ?>">
			<div class="row content-layout-wrapper">
		<?php
	}
}

// **********************************************************************// 
// ! Page bottom part
// **********************************************************************// 

if( ! function_exists( 'woodmart_page_bottom_part' ) ) {
	function woodmart_page_bottom_part() {
		if ( ! woodmart_is_woo_ajax() ): ?>
			</div><!-- .main-page-wrapper --> 
		<?php 
		endif;
	}
}

// **********************************************************************// 
// ! owl carousel init function
// **********************************************************************// 

if( ! function_exists( 'woodmart_owl_carousel_init' ) ) {
	function woodmart_owl_carousel_init( $atts = array() ) {
		extract( shortcode_atts( woodmart_get_owl_atts(), $atts ) );

		$func_name = 'carousel_' . $carousel_id;
		$func_name = function() use( $carousel_id, $slides_per_view, $autoplay, $autoheight, $speed, $hide_pagination_control, $hide_prev_next_buttons, $scroll_per_page, $wrap, $dragEndSpeed  ) {
			
			$items = woodmart_get_owl_items_numbers( $slides_per_view );
			ob_start();
			?>

				jQuery( document ).ready(function( $ ) {

	                var owl = $("#<?php echo esc_js( $carousel_id ); ?> .owl-carousel");

					$( window ).bind( "vc_js", function() {
						owl.trigger('refresh.owl.carousel');
					} );

					var options = {
	            		rtl: $('body').hasClass('rtl'),
			            items: <?php echo esc_js( $items['desktop'] ); ?>, 
			            responsive: {
			            	979: {
			            		items: <?php echo esc_js( $items['desktop'] ); ?>
			            	},
			            	768: {
			            		items: <?php echo esc_js( $items['desktop_small'] ); ?>
			            	},
			            	479: {
			            		items: <?php echo esc_js( $items['tablet'] ); ?>
			            	},
			            	0: {
			            		items: <?php echo esc_js( $items['mobile'] ); ?>
			            	}
			            },
			            autoplay: <?php echo ($autoplay == 'yes') ? 'true' : 'false'; ?>,
			            autoplayTimeout: <?php echo esc_js( $speed ); ?>,
			            dots: <?php echo ($hide_pagination_control == 'yes') ? 'false' : 'true'; ?>,
			            nav: <?php echo ($hide_prev_next_buttons == 'yes') ? 'false' : 'true'; ?>,
			            autoheight: <?php echo ($autoheight == 'yes') ? 'false' : 'true'; ?>,
			            slideBy:  <?php echo ($scroll_per_page == 'yes') ? '\'page\'' : 1; ?>,
			            navText:false,
			            loop: <?php echo ($wrap == 'yes') ? 'true' : 'false'; ?>,
						dragEndSpeed: <?php echo esc_js( $dragEndSpeed ); ?>,
			            onRefreshed: function() {
			            	$(window).resize();
			            }
					};

	                owl.owlCarousel(options);

				});
			<?php
			return ob_get_clean();
		};

		if( $carousel_js_inline == 'yes' ) {
			echo '<script type="text/javascript">' . $func_name() . '</script>';
		} else {
    		wp_add_inline_script( 'woodmart-theme', $func_name(), 'after' );
		}
	}
}

if( ! function_exists( 'woodmart_get_owl_atts' ) ) {
	function woodmart_get_owl_atts() {
		return array(
			'carousel_id' => '5000',
			'speed' => '5000',
			'slides_per_view' => '1',
			'wrap' => '',
			'autoplay' => 'no',
			'autoheight' => 'no',
			'hide_pagination_control' => '',
			'hide_prev_next_buttons' => '',
			'carousel_js_inline' => 'no',
			'scroll_per_page' => 'yes',
			'dragEndSpeed' => 200,
		);
	}
}


// **********************************************************************// 
// ! Page title function
// **********************************************************************// 

if( ! function_exists( 'woodmart_page_title' ) ) {

	add_action( 'woodmart_after_header', 'woodmart_page_title', 10 );

	function woodmart_page_title() {
        global $wp_query, $post;

        // Remove page title for dokan store list page

        if( function_exists( 'dokan_is_store_page' )  && dokan_is_store_page() ) {
        	return '';
        }

		$page_id = 0;

		$disable     = false;
		$page_title  = true;
		$breadcrumbs = woodmart_get_opt( 'breadcrumbs' );

		$image = '';

		$style = '';

		$page_for_posts    = get_option( 'page_for_posts' );
		$page_for_shop     = get_option( 'woocommerce_shop_page_id' );
		$page_for_projects = woodmart_tpl2id( 'portfolio.php' );

		$title_class = 'page-title-';

		$title_color = $title_type = $title_size = 'default';

		// Get default styles from Options Panel
		$title_design = woodmart_get_opt( 'page-title-design' );

		$title_size = woodmart_get_opt( 'page-title-size' );

		$title_color = woodmart_get_opt( 'page-title-color' );

		$shop_title = woodmart_get_opt( 'shop_title' );
		$shop_categories = woodmart_get_opt( 'shop_categories' );


		// Set here page ID. Will be used to get custom value from metabox of specific PAGE | BLOG PAGE | SHOP PAGE.
		$page_id = woodmart_page_ID();


		if( $page_id != 0 ) {
			// Get meta value for specific page id
			$disable = get_post_meta( $page_id, '_woodmart_title_off', true );

			$image = get_post_meta( $page_id, '_woodmart_title_image', true );

			$custom_title_color = get_post_meta( $page_id, '_woodmart_title_color', true );
			$custom_title_bg_color = get_post_meta( $page_id, '_woodmart_title_bg_color', true );


			if( $image != '' ) {
				$style .= "background-image: url(" . $image . ");";
			}

			if( $custom_title_bg_color != '' ) {
				$style .= "background-color: " . $custom_title_bg_color . ";";
			}

			if( $custom_title_color != '' && $custom_title_color != 'default' ) {
				$title_color = $custom_title_color;
			}
		}

		if( $title_design == 'disable' ) $page_title = false;

		if( ! $page_title && ! $breadcrumbs ) $disable = true;

		if( $disable ) return;

		$title_class .= $title_type;
		$title_class .= ' title-size-'  . $title_size;
		$title_class .= ' color-scheme-' . $title_color;
		$title_class .= ' title-design-' . $title_design;

		// Heading for pages
		if( is_singular( 'page' ) && ( ! $page_for_posts || ! is_page( $page_for_posts ) ) ):
			$title = get_the_title();

			?>
				<div class="page-title <?php echo esc_attr( $title_class ); ?>" style="<?php echo esc_attr( $style ); ?>">
					<div class="container">
						<header class="entry-header">
							<?php if ( woodmart_woocommerce_installed() && ( is_cart() || is_checkout() ) ): ?>
								<?php woodmart_checkout_steps(); ?>
							<?php else: ?>
								<?php if( $page_title ): ?><h1 class="entry-title"><?php echo esc_html( $title ); ?></h1><?php endif; ?>
								<?php if( $breadcrumbs ) woodmart_breadcrumbs(); ?>
							<?php endif ?>
						</header><!-- .entry-header -->
					</div>
				</div>
			<?php
			return;
		endif;


		// Heading for blog and archives
		if( is_singular( 'post' ) || woodmart_is_blog_archive() ):

			$title = ( ! empty( $page_for_posts ) ) ? get_the_title( $page_for_posts ) : esc_html__( 'Blog', 'woodmart' );

			if( is_tag() ) {
				$title = esc_html__( 'Tag Archives: ', 'woodmart')  . single_tag_title( '', false ) ;
			}

			if( is_category() ) {
				$title = '<span>' . single_cat_title( '', false ) . '</span>'; 
			}

			if( is_date() ) {
				if ( is_day() ) :
					$title = esc_html__( 'Daily Archives: ', 'woodmart') . get_the_date();
				elseif ( is_month() ) :
					$title = esc_html__( 'Monthly Archives: ', 'woodmart') . get_the_date( _x( 'F Y', 'monthly archives date format', 'woodmart' ) );
				elseif ( is_year() ) :
					$title = esc_html__( 'Yearly Archives: ', 'woodmart') . get_the_date( _x( 'Y', 'yearly archives date format', 'woodmart' ) );
				else :
					$title = esc_html__( 'Archives', 'woodmart' );
				endif;
			}

			if ( is_author() ) {
				/*
				 * Queue the first post, that way we know what author
				 * we're dealing with (if that is the case).
				 *
				 * We reset this later so we can run the loop
				 * properly with a call to rewind_posts().
				 */
				the_post();

				$title = esc_html__( 'Posts by ', 'woodmart' ) . '<span class="vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" title="' . esc_attr( get_the_author() ) . '" rel="me">' . get_the_author() . '</a></span>';

				/*
				 * Since we called the_post() above, we need to
				 * rewind the loop back to the beginning that way
				 * we can run the loop properly, in full.
				 */
				rewind_posts();
			}

			if( is_search() ) {
				$title = esc_html__( 'Search Results for: ', 'woodmart' ) . get_search_query();
			}

			?>
				<div class="page-title <?php echo esc_attr( $title_class ); ?> title-blog" style="<?php echo esc_attr( $style ); ?>">
					<div class="container">
						<header class="entry-header">
							<?php if( $page_title ): ?><h1 class="entry-title"><?php echo ( $title ); ?></h1><?php endif; ?>
							<?php if( $breadcrumbs && !is_search() ) woodmart_breadcrumbs(); ?>
						</header><!-- .entry-header -->
					</div>
				</div>
			<?php
			return;
		endif;

		// Heading for portfolio
		if( is_singular( 'portfolio' ) || woodmart_is_portfolio_archive() ):

			$title = get_the_title( $page_for_projects );

			if( is_tax( 'project-cat' ) ) {
				$title = single_term_title( '', false );
			}

			?>
				<div class="page-title <?php echo esc_attr( $title_class ); ?> title-blog" style="<?php echo esc_attr( $style ); ?>">
					<div class="container">
						<header class="entry-header">
							<?php if( $page_title ): ?><h1 class="entry-title"><?php echo esc_html( $title ); ?></h1><?php endif; ?>
							<?php if( $breadcrumbs ) woodmart_breadcrumbs(); ?>
						</header><!-- .entry-header -->
					</div>
				</div>
			<?php
			return;
		endif;

		// Page heading for shop page
		if( woodmart_is_shop_archive()
			&& ( $shop_categories || $shop_title )
		 ):

			if( is_product_category() ) {

		        $cat = $wp_query->get_queried_object();

				$cat_image = woodmart_get_category_page_title_image( $cat );

				if( $cat_image != '') {
					$style = "background-image: url(" . $cat_image . ")";
				}
			}

			if( is_product_category() || is_product_tag() ) {
				$title_class .= ' with-back-btn';
			}

			if( ! $shop_title ) {
				$title_class .= ' without-title';
			}

			?>
				<?php if ( apply_filters( 'woocommerce_show_page_title', true ) && ! is_singular( "product" ) ) : ?>
					<div class="page-title <?php echo esc_attr( $title_class ); ?> title-shop" style="<?php echo esc_attr( $style ); ?>">
						<div class="container">
							<div class="nav-shop">

								<div class="shop-title-wrapper">
									<?php if ( is_product_category() || is_product_tag() ): ?>
										<?php woodmart_back_btn(); ?>
									<?php endif ?>

									<?php if ( $shop_title ): ?>
										<h1><?php woocommerce_page_title(); ?></h1>
									<?php endif ?>
								</div>
								
								<?php if( ! is_singular( "product" ) && $shop_categories ) woodmart_product_categories_nav(); ?>

							</div>
						</div>
					</div>
				<?php endif; ?>

			<?php
			
			return;
		endif;
	}
}

if( ! function_exists( 'woodmart_back_btn' ) ) {
	function woodmart_back_btn() {
		?>
			<a href="javascript:woodmartThemeModule.backHistory()" class="woodmart-back-btn woodmart-css-tooltip"><span><?php esc_html_e('Back to products', 'woodmart') ?></span></a>
		<?php
	}
}

// **********************************************************************// 
// ! Recursive function to get page title image for the category or 
// ! take it from some parent term
// **********************************************************************// 

if( ! function_exists( 'woodmart_get_category_page_title_image' ) ) {
	function woodmart_get_category_page_title_image( $cat ) {
		$taxonomy = 'product_cat';
		$meta_key = 'title_image';
		$cat_image = woodmart_tax_data( $taxonomy, $cat->term_id, $meta_key );
		if( $cat_image != '' ) {
			return $cat_image;
		} else if( ! empty( $cat->parent ) ) {
	    	$parent = get_term_by( 'term_id', $cat->parent, $taxonomy );
	    	return woodmart_get_category_page_title_image( $parent );
		} else {
			return '';
		}
	}
}



// **********************************************************************// 
// ! Breacdrumbs function
// ! Snippet from http://dimox.net/wordpress-breadcrumbs-without-a-plugin/
// **********************************************************************// 

if( ! function_exists( 'woodmart_breadcrumbs' ) ) {
	function woodmart_breadcrumbs() {

		/* === OPTIONS === */
		$text['home']     = esc_html__('Home', 'woodmart'); // text for the 'Home' link
		$text['category'] = esc_html__('Archive by Category "%s"', 'woodmart'); // text for a category page
		$text['search']   = esc_html__('Search Results for "%s" Query', 'woodmart'); // text for a search results page
		$text['tag']      = esc_html__('Posts Tagged "%s"', 'woodmart'); // text for a tag page
		$text['author']   = esc_html__('Articles Posted by %s', 'woodmart'); // text for an author page
		$text['404']      = esc_html__('Error 404', 'woodmart'); // text for the 404 page

		$show_current_post  = 0; // 1 - show current post
		$show_current   = 1; // 1 - show current post/page/category title in breadcrumbs, 0 - don't show
		$show_on_home   = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
		$show_home_link = 1; // 1 - show the 'Home' link, 0 - don't show
		$show_title     = 1; // 1 - show the title for the links, 0 - don't show
		$delimiter      = ' &raquo; '; // delimiter between crumbs
		$before         = '<span class="current">'; // tag before the current crumb
		$after          = '</span>'; // tag after the current crumb
		/* === END OF OPTIONS === */

		global $post;

		$home_link    = home_url('/');
		$link_before  = '<span typeof="v:Breadcrumb">';
		$link_after   = '</span>';
		$link_attr    = ' rel="v:url" property="v:title"';
		$link         = $link_before . '<a' . $link_attr . ' href="%1$s">%2$s</a>' . $link_after;
		$parent_id    = $parent_id_2 = ( ! empty($post) && is_a($post, 'WP_Post') ) ? $post->post_parent : 0;
		$frontpage_id = get_option('page_on_front');
		$projects_id  = woodmart_tpl2id( 'portfolio.php' );

		if (is_home() || is_front_page()) {

			if ($show_on_home == 1) echo '<div class="breadcrumbs"><a href="' . $home_link . '">' . $text['home'] . '</a></div>';

		} else {

			echo '<div class="breadcrumbs" xmlns:v="http://rdf.data-vocabulary.org/#">';
			if ($show_home_link == 1) {
				echo '<a href="' . $home_link . '" rel="v:url" property="v:title">' . $text['home'] . '</a>';
				if ($frontpage_id == 0 || $parent_id != $frontpage_id) echo esc_html( $delimiter );
			}

			if ( is_category() ) {
				$this_cat = get_category(get_query_var('cat'), false);
				if ($this_cat->parent != 0) {
					$cats = get_category_parents($this_cat->parent, TRUE, $delimiter);
					if ($show_current == 0) $cats = preg_replace("#^(.+)$delimiter$#", "$1", $cats);
					$cats = str_replace('<a', $link_before . '<a' . $link_attr, $cats);
					$cats = str_replace('</a>', '</a>' . $link_after, $cats);
					if ($show_title == 0) $cats = preg_replace('/ title="(.*?)"/', '', $cats);
					echo $cats;
				}
				if ($show_current == 1) echo $before . sprintf($text['category'], single_cat_title('', false)) . $after;

			} elseif( is_tax( 'project-cat' ) ) {
				printf($link, get_the_permalink( $projects_id ), get_the_title( $projects_id ));
			} elseif ( is_search() ) {
				echo $before . sprintf($text['search'], get_search_query()) . $after;

			} elseif ( is_day() ) {
				echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
				echo sprintf($link, get_month_link(get_the_time('Y'),get_the_time('m')), get_the_time('F')) . $delimiter;
				echo $before . get_the_time('d') . $after;

			} elseif ( is_month() ) {
				echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
				echo $before . get_the_time('F') . $after;

			} elseif ( is_year() ) {
				echo $before . get_the_time('Y') . $after;

			} elseif ( is_single() && !is_attachment() ) {
				if( get_post_type() == 'portfolio' ) {
					printf($link, get_the_permalink( $projects_id ), get_the_title( $projects_id ));
					if ($show_current == 1) echo esc_html( $delimiter ) . $before . get_the_title() . $after;

				} else if ( get_post_type() != 'post' ) {
					$post_type = get_post_type_object(get_post_type());
					$slug = $post_type->rewrite;
					printf($link, $home_link . $slug['slug'] . '/', $post_type->labels->singular_name);
					if ($show_current == 1) echo esc_html( $delimiter ) . $before . get_the_title() . $after;
				} else {
					$cat = get_the_category(); $cat = $cat[0];
					$cats = get_category_parents($cat, TRUE, $delimiter);
					if ($show_current == 0) $cats = preg_replace("#^(.+)$delimiter$#", "$1", $cats);
					$cats = str_replace('<a', $link_before . '<a' . $link_attr, $cats);
					$cats = str_replace('</a>', '</a>' . $link_after, $cats);
					if ($show_title == 0) $cats = preg_replace('/ title="(.*?)"/', '', $cats);
					echo $cats;
					if ($show_current_post == 1) echo $before . get_the_title() . $after;
				}

			} elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
				$post_type = get_post_type_object(get_post_type());
				if ( is_object( $post_type ) ) {
					echo $before . $post_type->labels->singular_name . $after;
				}
				
			} elseif ( is_attachment() ) {
				$parent = get_post($parent_id);
				$cat = get_the_category($parent->ID); $cat = $cat[0];
				if ($cat) {
					$cats = get_category_parents($cat, TRUE, $delimiter);
					$cats = str_replace('<a', $link_before . '<a' . $link_attr, $cats);
					$cats = str_replace('</a>', '</a>' . $link_after, $cats);
					if ($show_title == 0) $cats = preg_replace('/ title="(.*?)"/', '', $cats);
					echo $cats;
				}
				printf($link, get_permalink($parent), $parent->post_title);
				if ($show_current == 1) echo esc_html( $delimiter ) . $before . get_the_title() . $after;

			} elseif ( is_page() && !$parent_id ) {
				if ($show_current == 1) echo $before . get_the_title() . $after;

			} elseif ( is_page() && $parent_id ) {
				if ($parent_id != $frontpage_id) {
					$breadcrumbs = array();
					while ($parent_id) {
						$page = get_page($parent_id);
						if ($parent_id != $frontpage_id) {
							$breadcrumbs[] = sprintf($link, get_permalink($page->ID), get_the_title($page->ID));
						}
						$parent_id = $page->post_parent;
					}
					$breadcrumbs = array_reverse($breadcrumbs);
					for ($i = 0; $i < count($breadcrumbs); $i++) {
						echo $breadcrumbs[$i];
						if ($i != count($breadcrumbs)-1) echo esc_html( $delimiter );
					}
				}
				if ($show_current == 1) {
					if ($show_home_link == 1 || ($parent_id_2 != 0 && $parent_id_2 != $frontpage_id)) echo esc_html( $delimiter );
					echo $before . get_the_title() . $after;
				}

			} elseif ( is_tag() ) {
				echo $before . sprintf($text['tag'], single_tag_title('', false)) . $after;

			} elseif ( is_author() ) {
		 		global $author;
				$userdata = get_userdata($author);
				echo $before . sprintf($text['author'], $userdata->display_name) . $after;

			} elseif ( is_404() ) {
				echo $before . $text['404'] . $after;

			} elseif ( has_post_format() && !is_singular() ) {
				echo get_post_format_string( get_post_format() );
			}

			if ( get_query_var('paged') ) {
				if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
				echo esc_html__('Page', 'woodmart' ) . ' ' . get_query_var('paged');
				if ( is_category() || is_day() ||
				 is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
			}

			echo '</div><!-- .breadcrumbs -->';

		}
	}
}

// **********************************************************************// 
// ! Products small grid
// **********************************************************************// 

if( ! function_exists( 'woodmart_products_widget_template' )) {
	function woodmart_products_widget_template($upsells, $small_grid = false) {
		global $product;
		echo '<ul class="product_list_widget">';
		foreach ( $upsells as $upsells_poduct )  {
			$product = $upsells_poduct;
			if( $small_grid ) {
				wc_get_template( 'content-widget-small.php' );
			} else {
				wc_get_template( 'content-widget-product.php', array( 'show_rating' => false ) );
			}
		}
		echo '</ul>';
		wp_reset_postdata();
	}
}

// **********************************************************************// 
// ! Promo popup
// **********************************************************************// 

if( ! function_exists( 'woodmart_promo_popup' ) ) {
	add_action( 'woodmart_after_footer', 'woodmart_promo_popup', 200 );

	function woodmart_promo_popup() {
		if( ! woodmart_get_opt( 'promo_popup' ) ) return;

		?>
			<div class="mfp-with-anim woodmart-promo-popup">
				<div class="woodmart-popup-inner">
					<?php echo do_shortcode( woodmart_get_opt( 'popup_text' ) ); ?>
				</div>
			</div>
		<?php
	}
}

// **********************************************************************// 
// ! Cookies law popup
// **********************************************************************// 

if( ! function_exists( 'woodmart_cookies_popup' ) ) {
	add_action( 'woodmart_after_footer', 'woodmart_cookies_popup', 300 );

	function woodmart_cookies_popup() {
		if( ! woodmart_get_opt( 'cookies_info' ) ) return;

		$page_id = woodmart_get_opt( 'cookies_policy_page' );

		?>
			<div class="woodmart-cookies-popup">
				<div class="woodmart-cookies-inner">
					<div class="cookies-info-text">
						<?php echo do_shortcode( woodmart_get_opt( 'cookies_text' ) ); ?>
					</div>
					<div class="cookies-buttons">
						<?php if ( $page_id ): ?>
							<a href="<?php echo get_permalink( $page_id ); ?>" class="cookies-more-btn"><?php esc_html_e( 'More info' , 'woodmart' ); ?></a>
						<?php endif ?>
						<a href="#" class="btn btn-size-small btn-color-primary cookies-accept-btn"><?php esc_html_e( 'Accept' , 'woodmart' ); ?></a>
					</div>
				</div>
			</div>
		<?php
	}
}


// **********************************************************************// 
// ! Header blocks
// **********************************************************************// 


if( ! function_exists( 'woodmart_header_block_logo' ) ) {
	function woodmart_header_block_logo() {

		$header_color_scheme = woodmart_get_opt( 'header_color_scheme' );

		// Get the logo
		$logo 		= WOODMART_IMAGES . '/wood-logo-dark.svg';
		$logo_white = WOODMART_IMAGES . '/wood-logo-white.svg';

		$protocol = woodmart_http() . "://";

		$logo_uploaded = woodmart_get_opt('logo');
		$logo_white_uploaded = woodmart_get_opt('logo-white');
		$logo_sticky_uploaded = woodmart_get_opt('logo-sticky');
		$has_sticky_logo = ( isset( $logo_sticky_uploaded['url'] ) && ! empty( $logo_sticky_uploaded['url'] ) );

		if(isset($logo_white_uploaded['url']) && $logo_white_uploaded['url'] != '') {
			$logo_white = $logo_white_uploaded['url'];
		}
		if(isset($logo_uploaded['url']) && $logo_uploaded['url'] != '') {
			$logo = $logo_uploaded['url'];
		}

		if( $header_color_scheme == 'light' ) {
			$logo = $logo_white;
		}

		$logo = $protocol. str_replace(array('http://', 'https://'), '', $logo);

		?>
			<div class="site-logo">
				<div class="woodmart-logo-wrap<?php if( $has_sticky_logo ) echo " switch-logo-enable"; ?>">
					<a href="<?php echo esc_url( home_url('/') ); ?>" class="woodmart-logo woodmart-main-logo" rel="home">
						<?php echo '<img src="' . $logo . '" alt="' . get_bloginfo( 'name' ) . '" />'; ?>
					</a>
					<?php if ( $has_sticky_logo ): ?>
						<?php 
							$logo_sticky = $protocol . str_replace( array( 'http://', 'https://' ), '', $logo_sticky_uploaded['url'] );
						 ?>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="woodmart-logo woodmart-sticky-logo" rel="home">
							<?php echo '<img src="' . $logo_sticky . '" alt="' . get_bloginfo( 'name' ) . '" />'; ?>
						</a>
					<?php endif ?>
				</div>
			</div>
		<?php
	}
}

if( ! function_exists( 'woodmart_header_block_widget_area' ) ) {
	function woodmart_header_block_widget_area() {
		?>
			<div class="widgetarea-head">
				<?php
					if( is_active_sidebar( 'header-widgets' ) ) {
						dynamic_sidebar( 'header-widgets' );
					}
				?>
			</div>
		<?php
	}
}

if( ! function_exists( 'woodmart_header_block_wishlist' ) ) {
	function woodmart_header_block_wishlist( $return = false ) {
		ob_start();
		if ( woodmart_woocommerce_installed() && class_exists( 'YITH_WCWL' ) && ( woodmart_get_opt('header_wishlist') == 'header' || $return ) ): ?>
			<div class="woodmart-wishlist-info-widget">
				<a href="<?php echo esc_url(YITH_WCWL()->get_wishlist_url()); ?>"><span class="wishlist-info-wrap"><span class="wishlist-label"><?php esc_html_e( 'Wishlist', 'woodmart' ) ?></span> <span class="wishlist-count"><?php echo YITH_WCWL()->count_products(); ?></span></span></a>
			</div>
		<?php endif;
		$out = ob_get_clean();
		if( $return ) return $out;
		echo $out;
	}
}

if( ! function_exists( 'woodmart_header_block_cart' ) ) {
	function woodmart_header_block_cart() {
		$position = woodmart_get_opt('cart_position');
		$design = woodmart_get_opt('shopping_cart');
		$extra_class = 'woodmart-cart-icon';

		if(  woodmart_get_opt('shopping_icon_alt') ) {
			$extra_class .= ' woodmart-cart-alt';
		}

		if( $position == 'side' ) {
			$extra_class .= ' cart-widget-opener';
		}
		
		if ( woodmart_woocommerce_installed() && $design != 'disable' ): ?>

			<div class="woodmart-shopping-cart woodmart-cart-design-<?php echo esc_attr( $design ); ?> <?php echo esc_attr( $extra_class ); ?>">
				<a href="<?php echo esc_url( wc_get_cart_url() ); ?>">
					<span class="cart-info-wrap">
						<span class="woodmart-cart-totals">
							<?php woodmart_cart_count(); ?>
							<span class="subtotal-divider">/</span> 
							<?php woodmart_cart_subtotal(); ?>
						</span>
					</span>
				</a>
				<?php if ( $position != 'side'): ?>
					<div class="dropdown-cart">
						 <?php 

							// Insert cart widget placeholder - code in woocommerce.js will update this on page load
							echo '<div class="widget woocommerce widget_shopping_cart"><div class="widget_shopping_cart_content"></div></div>';


						  ?> 
					</div>
				<?php endif ?>
			</div>
		<?php endif;
	}
}

if( ! function_exists( 'woodmart_header_block_search' ) ) {
	function woodmart_header_block_search() {
		$header_search = woodmart_get_opt( 'header_search' );
		$mobile_search_icon = woodmart_get_opt( 'mobile_search_icon' );
		$classes = '';
		
		if( $header_search == 'disable' ) return;
		
		if ( $mobile_search_icon ) $classes .= 'mobile-search-icon';
		?>
			<div class="search-button <?php echo esc_attr( $classes ); ?>">
				<a href="#"></a>
				<?php if ( $header_search == 'dropdown' ): ?>
					<?php woodmart_get_search_template(); ?>
				<?php endif; ?>
			</div>
		<?php
	}
}

if( ! function_exists( 'woodmart_get_search_template' ) ) {
	function woodmart_get_search_template() {
		$header_search = woodmart_get_opt( 'header_search' );
		$count = ( $header_search == 'dropdown' ) ? 20 : 40;
		$ajax_args = apply_filters('woodmart_ajax_search_args', array('thumbnail' => 1, 'price' => 1, 'count' => $count) );
		
		$classes = 'wrapper-search-' . $header_search;

		?>
		<div class="<?php echo esc_attr( $classes ); ?>">
			<span class="woodmart-close-search"><?php esc_html_e('close', 'woodmart'); ?></span>
			<?php woodmart_header_block_search_extended( false, false, true, $ajax_args, false ); ?>
		</div>
		<?php
	}
}

if( ! function_exists( 'woodmart_header_block_search_extended' ) ) {
	function woodmart_header_block_search_extended( $search_type = false, $show_categories = true, $ajax = true, $ajax_args = array(), $wrap = true ) {
		$class = '';
		$data  = '';

		$ajax_opt = woodmart_get_opt( 'search_ajax' );

		if( ! $ajax_opt ) $ajax = false;

		$search_post_type = woodmart_get_opt('search_post_type');

		if ( $search_type ) $search_post_type = $search_type;

		$defaults = array(
			'thumbnail' => true,
			'price' => true,
			'post-type' => $search_post_type,
			'count' => 15
		);

		if( $show_categories ) {
			$class .= ' has-categories-dropdown';
		} 

		/**
		 * Parse incoming $args into an array and merge it with $defaults
		 */ 
		$ajax_args = wp_parse_args( $ajax_args, $defaults );

		if( $ajax ) {
			$class .= ' woodmart-ajax-search';
			foreach ($ajax_args as $key => $value) {
				$data .= ' data-' . $key . '="' . $value . '"';
			}
		}

		switch ( $search_post_type ) {
			case 'product':
				$placeholder = esc_attr_x( 'Search for products', 'submit button', 'woodmart' );
				$description = esc_html__( 'Start typing to see products you are looking for.', 'woodmart' );
				break;
			case 'portfolio':
				$placeholder = esc_attr_x( 'Search for projects', 'submit button', 'woodmart' );
				$description = esc_html__( 'Start typing to see projects you are looking for.', 'woodmart' );
				break;
			
			default:
				$placeholder = esc_attr_x( 'Search for posts', 'submit button', 'woodmart' );
				$description = esc_html__( 'Start typing to see posts you are looking for.', 'woodmart' );
				break;
		}

		if( $wrap ) echo '<div class="search-extended">';
		?>
			<form role="search" method="get" class="searchform <?php echo esc_attr( $class ); ?>" action="<?php echo esc_url( home_url( '/' ) ); ?>" <?php echo ( $data ); ?>>
				<div>
					<label class="screen-reader-text" for="s"><?php esc_attr_x( 'Search for:', 'label', 'woodmart' ); ?></label>
					<input type="text" class="s" placeholder="<?php echo ($placeholder); ?>" value="<?php echo get_search_query(); ?>" name="s" />
					<input type="hidden" name="post_type" value="<?php echo esc_attr( $search_post_type ); ?>">
					<?php if( $show_categories && $search_post_type == 'product' ) woodmart_show_categories_dropdown(); ?>
					<button type="submit" class="searchsubmit"><?php echo esc_attr_x( 'Search', 'submit button', 'woodmart' ); ?></button>
				</div>
			</form>
			<div class="search-info-text"><span><?php echo ($description); ?></span></div>
			<div class="search-results-wrapper"><div class="woodmart-scroll"><div class="woodmart-search-results woodmart-scroll-content"></div></div><div class="woodmart-search-loader"></div></div>
		<?php
		if( $wrap ) echo '</div>';
	}
}

if( ! function_exists( 'woodmart_show_categories_dropdown' ) ) {
	function woodmart_show_categories_dropdown() {
		if( ! woodmart_get_opt( 'search_categories' ) ) return;
		$args = array( 
			'hide_empty' => 1,
			'parent' => 0
		);
		$terms = get_terms('product_cat', $args);
		if( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
			?>
			<div class="search-by-category input-dropdown">
				<div class="input-dropdown-inner woodmart-scroll-content">
					<input type="hidden" name="product_cat" value="0">
					<a href="#" data-val="0"><?php esc_html_e('Select category', 'woodmart'); ?></a>
					<div class="list-wrapper woodmart-scroll">
						<ul class="woodmart-scroll-content">
							<li style="display:none;"><a href="#" data-val="0"><?php esc_html_e('Select category', 'woodmart'); ?></a></li>
							<?php
								if( ! apply_filters( 'woodmart_show_only_parent_categories_dropdown', false ) ) {
							        $args = array(
							            'orderby' => 'id',
							            'title_li' => false,
							            'taxonomy' => 'product_cat',
							            'walker' => new WOODMART_Custom_Walker_Category(),
							        );
							        wp_list_categories($args);
								} else {
								    foreach ( $terms as $term ) {
								    	?>
											<li><a href="#" data-val="<?php echo esc_attr( $term->slug ); ?>"><?php echo esc_attr( $term->name ); ?></a></li>
								    	<?php
								    }
								}
							?>
						</ul>
					</div>
				</div>
			</div>
			<?php
		}
	}
}
class WOODMART_Custom_Walker_Category extends Walker_Category {

    public function start_el( &$output, $category, $depth = 0, $args = array(), $id = 0 ) {
		/** This filter is documented in wp-includes/category-template.php */
		$cat_name = apply_filters(
			'list_cats',
			esc_attr( $category->name ),
			$category
		);

		// Don't generate an element if the category name is empty.
		if ( ! $cat_name ) {
			return;
		}

		$link = '<a href="' . esc_url( get_term_link( $category ) ) . '" data-val="' . esc_attr( $category->slug ) . '" ';
		if ( $args['use_desc_for_title'] && ! empty( $category->description ) ) {
			/**
			 * Filters the category description for display.
			 *
			 * @since 1.2.0
			 *
			 * @param string $description Category description.
			 * @param object $category    Category object.
			 */
			$link .= 'title="' . esc_attr( strip_tags( apply_filters( 'category_description', $category->description, $category ) ) ) . '"';
		}

		$link .= '>';
		$link .= $cat_name . '</a>';

		if ( ! empty( $args['feed_image'] ) || ! empty( $args['feed'] ) ) {
			$link .= ' ';

			if ( empty( $args['feed_image'] ) ) {
				$link .= '(';
			}

			$link .= '<a href="' . esc_url( get_term_feed_link( $category->term_id, $category->taxonomy, $args['feed_type'] ) ) . '"';

			if ( empty( $args['feed'] ) ) {
				$alt = ' alt="' . sprintf(esc_html__( 'Feed for all posts filed under %s', 'woodmart' ), $cat_name ) . '"';
			} else {
				$alt = ' alt="' . $args['feed'] . '"';
				$name = $args['feed'];
				$link .= empty( $args['title'] ) ? '' : $args['title'];
			}

			$link .= '>';

			if ( empty( $args['feed_image'] ) ) {
				$link .= $name;
			} else {
				$link .= "<img src='" . $args['feed_image'] . "'$alt" . ' />';
			}
			$link .= '</a>';

			if ( empty( $args['feed_image'] ) ) {
				$link .= ')';
			}
		}

		if ( ! empty( $args['show_count'] ) ) {
			$link .= ' (' . number_format_i18n( $category->count ) . ')';
		}
		if ( 'list' == $args['style'] ) {
			$output .= "\t<li";
			$css_classes = array(
				'cat-item',
				'cat-item-' . $category->term_id,
			);

			if ( ! empty( $args['current_category'] ) ) {
				// 'current_category' can be an array, so we use `get_terms()`.
				$_current_terms = get_terms( $category->taxonomy, array(
					'include' => $args['current_category'],
					'hide_empty' => false,
				) );

				foreach ( $_current_terms as $_current_term ) {
					if ( $category->term_id == $_current_term->term_id ) {
						$css_classes[] = 'current-cat';
					} elseif ( $category->term_id == $_current_term->parent ) {
						$css_classes[] = 'current-cat-parent';
					}
					while ( $_current_term->parent ) {
						if ( $category->term_id == $_current_term->parent ) {
							$css_classes[] =  'current-cat-ancestor';
							break;
						}
						$_current_term = get_term( $_current_term->parent, $category->taxonomy );
					}
				}
			}

			/**
			 * Filters the list of CSS classes to include with each category in the list.
			 *
			 * @since 4.2.0
			 *
			 * @see wp_list_categories()
			 *
			 * @param array  $css_classes An array of CSS classes to be applied to each list item.
			 * @param object $category    Category data object.
			 * @param int    $depth       Depth of page, used for padding.
			 * @param array  $args        An array of wp_list_categories() arguments.
			 */
			$css_classes = implode( ' ', apply_filters( 'category_css_class', $css_classes, $category, $depth, $args ) );

			$output .=  ' class="' . $css_classes . '"';
			$output .= ">$link\n";
		} elseif ( isset( $args['separator'] ) ) {
			$output .= "\t$link" . $args['separator'] . "\n";
		} else {
			$output .= "\t$link<br />\n";
		}
	} 
} 
if( ! function_exists( 'woodmart_header_block_categories_menu' ) ) {
	function woodmart_header_block_categories_menu() {
		$categories_menu = woodmart_get_opt( 'categories-menu' );
		if( $categories_menu == '' ) return;
		
		$opened = false;

		$opened = get_post_meta( woodmart_get_the_ID(), '_woodmart_open_categories', true );

		if ( woodmart_woocommerce_installed() && is_product() ) $opened = false;

		$color = woodmart_get_opt( 'categories_menu_color_scheme' );
		$bg = woodmart_get_opt( 'categories_menu_background' );

		$class = ( $color != 'inherit') ? 'color-scheme-' . $color : '';
		if ( ! empty( $bg ) && ! empty( $bg['background-color'] ) ) {
			$class .= ' has-bg';
		}
		
		?>
			<div class="vertical-navigation header-categories-nav <?php if( $opened ) echo 'opened-menu'; else echo 'show-on-hover'; ?>" role="navigation">
				<span class="menu-opener <?php echo esc_attr( $class ); ?>">
					<span class="menu-open-label">
						<span class="burger-icon"></span><?php esc_html_e('Browse Categories', 'woodmart'); ?>
					</span>
					<span class="arrow-opener"></span>
				</span>
				<div class="categories-menu-dropdown woodmart-navigation">
					<?php 
						wp_nav_menu(
							array(
								'menu' => $categories_menu,
								'menu_class' => 'menu',
								'walker' => new WOODMART_Mega_Menu_Walker()
							)
						);
					 ?>
				</div>
			</div>
		<?php
	}
}

if( ! function_exists( 'woodmart_header_block_main_nav' ) ) {
	function woodmart_header_block_main_nav() {
		if( woodmart_get_opt( 'full_screen_menu' ) ) return;

		$menu_style = ( woodmart_get_opt( 'menu_style' ) ) ? woodmart_get_opt( 'menu_style' ) : 'default';
		$location = apply_filters( 'woodmart_main_menu_location', 'main-menu' );
		$classes = 'menu-' . woodmart_get_opt('menu_align');
		$classes .= ' navigation-style-' . $menu_style;
		$classes .= ' main-nav';

		woodmart_get_main_nav( $classes, $location );
	}
}


if( ! function_exists( 'woodmart_header_block_menu_text' ) ) {
	function woodmart_header_block_menu_text() {
		$text = woodmart_get_opt( 'header-menu-text' );
		if( empty( $text ) ) return;
		?>
			<div class="menu-text-widget">
				<?php echo do_shortcode( $text ); ?>
			</div>
		<?php
	}
}

if( ! function_exists( 'woodmart_header_block_mobile_nav' ) ) {
	function woodmart_header_block_mobile_nav() {

		$menu_locations = get_nav_menu_locations();

		$location = apply_filters( 'woodmart_main_menu_location', 'main-menu' );
		
		$menu_link = get_admin_url( null, 'nav-menus.php' );
		
		$ajax_args = apply_filters( 'woodmart_ajax_search_args', array( 'thumbnail' => 1, 'price' => 1, 'count' => 20 ) );

		echo '<div class="mobile-nav">';

		?>
				<?php 
				
					woodmart_header_block_search_extended( false, false, true, $ajax_args, false );
					
					if( woodmart_get_opt('mobile_categories') ) {
						?>
							<div class="mobile-nav-tabs">
								<ul>
									<li class="mobile-tab-title mobile-pages-title active" data-menu="pages"><span><?php esc_html_e('Menu', 'woodmart'); ?></span></li>
									<li class="mobile-tab-title mobile-categories-title" data-menu="categories"><span><?php esc_html_e('Categories', 'woodmart'); ?></span></li>
								</ul>
							</div>
						<?php
						echo '<div class="mobile-menu-tab mobile-categories-menu">';
						
						$mobile_categories_menu = woodmart_get_opt( 'mobile_categories_menu' );
						if( ! empty( $mobile_categories_menu ) ) {
							wp_nav_menu(
								array(
									'menu' => $mobile_categories_menu,
									'menu_class' => 'site-mobile-menu',
									'walker' => new WOODMART_Mega_Menu_Walker()
								)
							);
						} else {
							?>
								<span class="create-nav-msg"><?php esc_html_e('Set your categories menu in Theme Settings -> Header -> Menu -> Mobile menu (categories)', 'woodmart'); ?></span>
							<?php
						}

						echo '</div>';
					}

					echo '<div class="mobile-menu-tab mobile-pages-menu active">';

					if( isset( $menu_locations['mobile-menu'] ) && $menu_locations['mobile-menu'] != 0 ) {
						$location = 'mobile-menu';
					}

					if( has_nav_menu( $location ) ) {
						wp_nav_menu(
							array(
								'theme_location' => $location,
								'menu_class' => 'site-mobile-menu',
								'walker' => new WOODMART_Mega_Menu_Walker()
							)
						);
					} else {
						?><span class="create-nav-msg">
							<?php 
								printf( 
									wp_kses( __('Create your first <a href="%s"><strong>navigation menu here</strong></a>', 'woodmart')
										, array(
											'a' => array(
												'href' => array()
											)
										)
									)	
								, $menu_link);
							?>
							</span><?php
					}

					echo '</div>';

				 ?>

				<?php if( is_active_sidebar( 'header-widgets' ) ): ?>
						<div class="widgetarea-mobile">
							<?php dynamic_sidebar( 'mobile-menu-widgets' ); ?>	
						</div>
				<?php endif; ?>
		<?php

		echo '</div><!--END MOBILE-NAV-->';
	}
}


if( ! function_exists( 'woodmart_header_block_mobile_icon' ) ) {
	function woodmart_header_block_mobile_icon() {
		?>
			<div class="woodmart-burger-icon mobile-nav-icon">
				<span class="woodmart-burger"></span>
				<span class="woodmart-burger-label"><?php esc_html_e('Menu', 'woodmart'); ?></span>
			</div><!--END MOBILE-NAV-ICON-->
		<?php
	}
}

if( ! function_exists( 'woodmart_header_block_header_links' ) ) {
	function woodmart_header_block_header_links() {
		if( ! woodmart_get_opt( 'header_links' ) ) return;

		$links = woodmart_get_header_links();
		$my_account_style = woodmart_get_opt( 'header_my_account_style' );
		
		$classes = 'item-level-0';
		$classes .= ( ! empty( $link['dropdown'] ) ) ? ' menu-item-has-children' : '';
		$classes .= ( woodmart_get_opt( 'links_with_username' ) ) ? ' my-account-with-username' : '';
		$classes .= ( $my_account_style ) ? ' my-account-with-' . $my_account_style : '';
		
		if( ! empty( $links ) ) {
		?>
			<div class="woodmart-header-links">
				<ul>
					<?php foreach ($links as $key => $link):
						$classes .= ' menu-item-'. $key;
					?>
						<li class="<?php echo esc_attr( $classes ); ?>"><a href="<?php echo esc_url( $link['url'] ); ?>"><span><?php echo wp_kses( $link['label'], 'default' ); ?></span></a>
							<?php if( ! empty( $link['dropdown'] ) ) {
								echo $link['dropdown'];
							} ?></li>
					<?php endforeach; ?>
				</ul>		
			</div>
		<?php
		}
	}
}

if( ! function_exists( 'woodmart_get_header_links' ) ) {
	function woodmart_get_header_links() {
		$links = array();

		if( ! woodmart_woocommerce_installed() || !woodmart_get_opt( 'header_links' ) && !woodmart_get_opt( 'topbar_links' ) ) return $links;

		$account_link = get_permalink( get_option('woocommerce_myaccount_page_id') );

		$color_scheme = ( woodmart_get_opt( 'header_dropdowns_dark' ) ) ? 'light' : 'dark';

		$current_user = wp_get_current_user();

		if( is_user_logged_in() ) {
			$links['my-account'] = array(
				'label' => esc_html__('My Account', 'woodmart'),
				'url' => $account_link,
				'dropdown' => '
					<div class="sub-menu-dropdown color-scheme-' . $color_scheme . '">
						' . woodmart_get_my_account_menu() . '
					</div>
				'
			);
			if ( woodmart_get_opt( 'links_with_username' ) ) {
				$links['my-account']['label'] = sprintf( esc_html__( 'Hello, %s', 'woodmart' ), '<strong>' . esc_html( $current_user->display_name ) . '</strong>' );
			}
		} else {
			$links['register'] = array(
				'label' => esc_html__('Login / Register', 'woodmart'),
				'url' => $account_link
			);

			if( woodmart_get_opt( 'login_dropdown' ) ) {
				$links['register']['dropdown'] = '
					<div class="sub-menu-dropdown color-scheme-' . $color_scheme . '">
						<div class="login-dropdown-inner">
							<h3 class="login-title"><span>' . esc_html__('Sign in', 'woodmart') . '</span><a class="create-account-link" href="' . esc_url( $account_link ) . '">' . esc_html__('Create an Account', 'woodmart') . '</a>' . '</h3>
							' . woodmart_login_form( false, $account_link ) . '
						</div>
					</div>
				';
			}
		}

		return apply_filters( 'woodmart_get_header_links',  $links );
	}
}

// **********************************************************************// 
// ! Add account links to the top bat menu
// **********************************************************************// 

if( ! function_exists( 'woodmart_topbar_links' ) ) {
	add_filter( 'wp_nav_menu_items', 'woodmart_topbar_links', 50, 2 );
	function woodmart_topbar_links ( $items = '', $args = array(), $return = false ) {
	    if ( 
	    		( 
	    			! empty( $args ) 
	    			&& 
					(
						$args->theme_location == 'top-bar-menu'
						||
						$args->theme_location == 'mobile-menu'
					) 
				) 
	    		|| $return 
    		) {

	    	if( woodmart_get_opt( 'header_wishlist' ) == 'topbar' || ( woodmart_get_opt( 'header_wishlist' ) == 'header' && isset( $args ) && $args->theme_location == 'mobile-menu' ) ) {
		    	// Wishlist item firstly
				$items .= '<li class="menu-item item-level-0 menu-item-wishlist">';
				$items .= woodmart_header_block_wishlist( true );
				$items .= '</li>';
	    	}
	    	
			$links = woodmart_get_header_links();

			if( ! empty( $links ) && ( woodmart_get_opt( 'topbar_links' ) ||  $args->theme_location == 'mobile-menu' ) ){
				$my_account_style = woodmart_get_opt( 'header_my_account_style' );
				foreach ($links as $key => $link) {
					$classes = '';
					$classes .= ( woodmart_get_opt( 'links_with_username' ) ) ? ' my-account-with-username' : '';
					$classes .= ( $my_account_style ) ? ' my-account-with-' . $my_account_style : '';
					
					if( ! empty( $link['dropdown'] ) ) $classes .= ' menu-item-has-children';
					
					$items .= '<li class="menu-item item-level-0 ' . $classes . ' menu-item-' . $key . '">';
					$items .= '<a href="' . esc_url( $link['url'] ) . '">' . wp_kses( $link['label'], 'default' ) . '</a>';
					if( ! empty( $link['dropdown'] ) && ! ( ! empty( $args ) && $args->theme_location == 'mobile-menu' && $key == 'register' ) ) {
						$items .= $link['dropdown'];
					}
					$items .= '</li>';
				}
			}

	    }
	    return $items;
	}
}
// **********************************************************************// 
// ! My account menu
// **********************************************************************// 

if( ! function_exists( 'woodmart_get_my_account_menu' ) ) {
	function woodmart_get_my_account_menu() {
		$out = '<ul class="sub-menu">';

        foreach ( wc_get_account_menu_items() as $endpoint => $label ) {
            $out .= '<li class="' . wc_get_account_menu_item_classes( $endpoint ) . '"><a href="' . esc_url( wc_get_account_endpoint_url( $endpoint ) ) . '"><span>' . esc_html( $label ) . '</span></a></li>';
        }
		if ( class_exists( 'YITH_WCWL' ) && woodmart_get_opt( 'my_account_wishlist' ) ) {
			$wishlist_page_id = yith_wcwl_object_id( get_option( 'yith_wcwl_wishlist_page_id' ) );
			$out .= '<li class="woocommerce-MyAccount-navigation-link woocommerce-MyAccount-navigation-link--wishlist">
                <a href="' . YITH_WCWL()->get_wishlist_url() . '"><span>' . get_the_title( $wishlist_page_id ) . '</span></a>
            </li>';
		}
		if ( class_exists( 'WeDevs_Dokan' ) && apply_filters( 'woodmart_dokan_link', true ) ) {
			$out .= '<li class="woocommerce-MyAccount-navigation-link woocommerce-MyAccount-navigation-link--dokan">
				<a href="' . dokan_get_navigation_url() . '"><span>' . esc_html__( 'Vendor dashboard', 'woodmart' ) . '</span></a>
			</li>';
		}
		$out .= '<li class="woocommerce-MyAccount-navigation-link woocommerce-MyAccount-navigation-link--customer-logout">
           <a href="' . esc_url( wc_get_account_endpoint_url( 'customer-logout' ) ) . '"><span>' . esc_html__( 'Logout', 'woodmart' ) . '</span></a>
         </li>';

		return $out . '</ul>';
	}
}


// **********************************************************************// 
// ! Add account links to the top bat menu
// **********************************************************************// 

if( ! function_exists( 'woodmart_add_logout_link' ) ) {
	add_filter( 'wp_nav_menu_items', 'woodmart_add_logout_link', 10, 2 );
	function woodmart_add_logout_link ( $items = '', $args = array(), $return = false ) {
	    if ( ( ! empty( $args ) && $args->theme_location == 'header-account-menu' ) || $return ) {

			$links = array();

			$logout_link = wc_get_endpoint_url( 'customer-logout', '', wc_get_page_permalink( 'myaccount' ) );

			$links['logout'] = array(
				'label' => esc_html__( 'Logout', 'woodmart' ),
				'url' => $logout_link
			);

			if( ! empty( $links )) {
				foreach ($links as $key => $link) {
					$items .= '<li id="menu-item-' . $key . '" class="menu-item item-event-hover menu-item-' . $key . '">';
					$items .= '<a href="' . esc_url( $link['url'] ) . '">' . esc_attr( $link['label'] ) . '</a>';
					$items .= '</li>';
				}
			}
	    }
	    return $items;
	}
}


// **********************************************************************// 
// ! Login form HTML for top bar menu dropdown
// **********************************************************************// 

if( ! function_exists( 'woodmart_login_form' ) ) {
	function woodmart_login_form( $echo = true, $action = false, $message = false, $hidden = false, $redirect = false ) {

		ob_start();
        $vk_app_id         = woodmart_get_opt('vk_app_id');
        $vk_app_secret     = woodmart_get_opt('vk_app_secret');
        $fb_app_id         = woodmart_get_opt('fb_app_id');
        $fb_app_secret     = woodmart_get_opt('fb_app_secret');
        $goo_app_id        = woodmart_get_opt('goo_app_id');
        $goo_app_secret    = woodmart_get_opt('goo_app_secret');
		?>
			<form method="post" class="login <?php if ( $hidden ) echo 'hidden-form'; ?>" <?php echo ( ! empty( $action ) ) ? 'action="' . esc_url( $action ) . '"' : ''; ?> <?php if ( $hidden ) echo 'style="display:none;"'; ?>>

				<?php do_action( 'woocommerce_login_form_start' ); ?>

				<?php if ( $message ) echo wpautop( wptexturize( $message ) ); ?>

				<div class="close-login-form"><span><?php esc_html_e('Close', 'woodmart'); ?></span></div>

				<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide form-row-username">
					<label for="username"><?php esc_html_e( 'Username or email address', 'woodmart' ); ?> <span class="required">*</span></label>
					<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="username" value="<?php if ( ! empty( $_POST['username'] ) ) echo esc_attr( $_POST['username'] ); ?>" />
				</p>
				<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide form-row-password">
					<label for="password"><?php esc_html_e( 'Password', 'woodmart' ); ?> <span class="required">*</span></label>
					<input class="woocommerce-Input woocommerce-Input--text input-text" type="password" name="password" id="password" />
				</p>

				<?php do_action( 'woocommerce_login_form' ); ?>

				<p class="form-row">
					<?php wp_nonce_field( 'woocommerce-login' ); ?>
					<?php if ( $redirect ): ?>
						<input type="hidden" name="redirect" value="<?php echo esc_url( $redirect ) ?>" />
					<?php endif ?>
					<input type="submit" class="woocommerce-Button button" name="login" value="<?php esc_attr_e( 'Login', 'woodmart' ); ?>" />
				</p>

				<div class="login-form-footer">
					<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>" class="woocommerce-LostPassword lost_password"><?php esc_html_e( 'Lost your password?', 'woodmart' ); ?></a>
					<label for="rememberme" class="remember-me-label inline">
						<input name="rememberme" type="checkbox" value="forever" /> <?php esc_html_e( 'Remember me', 'woodmart' ); ?>
					</label>
				</div>

				<?php if ( class_exists( 'WOODMART_Auth' ) && ( ( ! empty( $fb_app_id ) && ! empty( $fb_app_secret ) ) || ( ! empty( $goo_app_id ) && ! empty( $goo_app_secret ) ) || ( ! empty( $vk_app_id ) && ! empty( $vk_app_secret ) ) ) ): ?>
					<span class="social-login-title"><?php esc_html_e('Or login with', 'woodmart'); ?></span>
					<div class="woodmart-social-login">
						<?php if ( ! empty( $fb_app_id ) && ! empty( $fb_app_secret ) ): ?>
							<div class="social-login-btn">
								<a href="<?php echo add_query_arg('social_auth', 'facebook', wc_get_page_permalink('myaccount')); ?>" class="login-fb-link"><?php esc_html_e( 'Facebook', 'woodmart' ); ?></a>
							</div>
						<?php endif ?>
						<?php if ( ! empty( $goo_app_id ) && ! empty( $goo_app_secret ) ): ?>
							<div class="social-login-btn">
								<a href="<?php echo add_query_arg('social_auth', 'google', wc_get_page_permalink('myaccount')); ?>" class="login-goo-link"><?php esc_html_e( 'Google', 'woodmart' ); ?></a>
							</div>
						<?php endif ?>
						<?php if ( ! empty( $vk_app_id ) && ! empty( $vk_app_secret ) ): ?>
							<div class="social-login-btn">
								<a href="<?php echo add_query_arg('social_auth', 'vkontakte', wc_get_page_permalink('myaccount')); ?>" class="login-vk-link"><?php esc_html_e( 'VKontakte', 'woodmart' ); ?></a>
							</div>
						<?php endif ?>
					</div>
				<?php endif ?>

				<?php do_action( 'woocommerce_login_form_end' ); ?>

			</form>

		<?php

		$out = ob_get_clean();
		if( $echo ) echo $out;
		else return $out;
	}
}


// **********************************************************************// 
// ! Generate Header functions. Based on array of blocks and divs
// **********************************************************************// 

if( ! function_exists( 'woodmart_generate_header' ) ) {
	function woodmart_generate_header( $header = 1) {

		$configuration = woodmart_get_header_configuration( $header );

		woodmart_process_child( apply_filters( 'woodmart_header_configuration', $configuration ) );

	}

		function woodmart_process_child( $configuration ) {
			foreach( $configuration as $key => $block) {
				woodmart_header_block( $key, $block );
			}
		}

		function woodmart_header_block($key, $block) {
			if( is_array($block) ) {
				ob_start();
				woodmart_process_child( $block );
				$output = ob_get_contents();
				ob_end_clean();

				// If block has child it is a div with class $key
				echo '<div class="' . esc_attr( $key ) . '">';
				if( ! empty( $output ) ) {
					echo $output;
				}	
				echo '</div>';
				
			} else {
				$func = 'woodmart_header_block_' . $block;
				if( function_exists( $func ) ) {
					$func();
				}
			}
		}

		function woodmart_get_header_configuration( $header = 'base' ) {
			$configurations = array();

			$bg = woodmart_get_opt( 'menu_background' );

			$navigation_wrap_class = 'navigation-wrap navigation-color-scheme-' . woodmart_get_opt( 'menu_color_scheme' );

			if ( ! empty( $bg ) && ! empty( $bg['background-color'] ) ) {
				$navigation_wrap_class .= ' has-bg';
			}

			$configurations['base'] = array(
				'container' => array(
					'wrapp-header' => array(
						'header-left-side' => array(
							'mobile_icon',
						),
						'logo',
						'widget_area',
						'right-column' => array(
							'header_links',
							'search',
							'wishlist',
							'cart',
							'full_screen_menu_icon',
						)
					)
				),
				$navigation_wrap_class => array(
					'container' => array(
						'navigations-inner' => array(
							'categories_menu',
							'main_nav',
							'menu_text'
						),
					)
				)
			);

			$configurations['simple'] = array(
				'container' => array(
					'wrapp-header' => array(
						'header-left-side' => array(
							'mobile_icon',
						),
						'logo',
						'main_nav',
						'right-column' => array(
							'header_links',
							'search',
							'wishlist',
							'cart',
							'full_screen_menu_icon',
						)
					)	
				),
			);

			$configurations['split'] = array(
				'container' => array(
					'wrapp-header' => array(
						'right-column left-side' => array(
							'mobile_icon',
							'full_screen_menu_icon',
							'search',
							'wishlist',
						),
						'logo',
						'main_nav',
						'right-column' => array(
							'header_links',
							'cart',
						)
					)	
				),
			);

			$configurations['logo-center'] = array(
				'container' => array(
					'wrapp-header' => array(
						'header-left-side' => array(
							'mobile_icon',
						),
						'widget_area',
						'logo',
						'right-column' => array(
							'header_links',
							'search',
							'wishlist',
							'cart',
							'full_screen_menu_icon',
						)
					)
				),
				$navigation_wrap_class => array(
					'container' => array(
						'main_nav'
					)
				)
			);

			$configurations['categories'] = array(
				'container' => array(
					'wrapp-header' => array(
						'header-left-side' => array(
							'mobile_icon',
						),
						'logo',
						'main_nav',
						'right-column' => array(
							'header_links',
							'search',
							'wishlist',
							'cart',
							'full_screen_menu_icon',
						)
					)	
				),
				'secondary-header' => array(
					'container' => array(
						'secondary-inner' => array(
							'categories_menu',
							'search_extended',
						)
					)
				)
			);

			$configurations['advanced'] = array(
				'container' => array(
					'wrapp-header' => array(
						'header-left-side' => array(
							'mobile_icon',
						),
						'logo',
						'widget_area',
						'search_extended',
						'right-column' => array(
							'cart',
						)
					)	
				),
				'secondary-header' => array(
					'container' => array(
						'secondary-inner' => array(
							'categories_menu',
							'woodmart-navbar' => array(
								'main_nav',
								'right-column' => array(
									'wishlist',
									'cart',
									'full_screen_menu_icon',
								)
							)
						)
					)
				)
			);

			$navigation_wrap_class .= '  wrapp-header';

			$configurations['menu-top'] = array(
				$navigation_wrap_class => array(
					'container' => array(
						'navigations-inner' => array(
							'header-left-side' => array(
								'mobile_icon',
								'full_screen_menu_icon',
							),
							'main_nav',
							'widget_area',
							'right-column' => array(
								'header_links',
								'search',
								'wishlist',
								'cart',
							)
						),
					),
				),
				'container' => array(
					'logo'
				)
			);

			$configurations['shop'] = array(
				'container' => array(
					'wrapp-header' => array(
						'header-left-side' => array(
							'mobile_icon',
							'full_screen_menu_icon',
						),
						'main_nav',
						'logo',
						'right-column' => array(
							'header_links',
							'search',
							'wishlist',
							'cart',
						)
					)	
				),
			);

			if( ! isset( $configurations[$header] ) ) {
				$header = 'base';
			}

			return $configurations[$header];
			
		} 
}


if ( !function_exists( 'woodmart_get_star_rating' ) ) { 
	function woodmart_get_star_rating( $rating ) {
		?>
			<div class="star-rating">
				<span style="width:<?php echo ( ( $rating / 5 ) * 100 ); ?>%">
					<?php
					printf(
						esc_html__( '%1$s out of %2$s', 'woodmart' ),
						'<strong class="rating">' . esc_html( $rating ) . '</strong>',
						'<span>5</span>'
					);
					?>
				</span>
			</div>
		<?php
	}
}

if ( !function_exists( 'woodmart_get_twitts' ) ) { 
	function woodmart_get_twitts( $args = array() ) {
		// Get the tweets from Twitter.
		if ( ! class_exists( 'TwitterOAuth' ) ) return;

		if ( !isset( $args['name'] ) || !isset( $args['consumer_key'] ) || !isset( $args['consumer_secret'] ) || !isset( $args['access_token'] ) || !isset( $args['accesstoken_secret'] ) ) {
			echo '<p>You must correctly enter the twitter access keys</p>';
		}

		if ( !isset( $args['name'] ) ) $args['name'] = 'Twitter';
		if ( !isset( $args['num_tweets'] ) ) $args['num_tweets'] = 5;
		if ( !isset( $args['consumer_key'] ) ) $args['consumer_key'] = '';
		if ( !isset( $args['consumer_secret'] ) ) $args['consumer_secret'] = '';
		if ( !isset( $args['access_token'] ) ) $args['access_token'] = '';
		if ( !isset( $args['accesstoken_secret'] ) ) $args['accesstoken_secret'] = '';

		$connection = new TwitterOAuth(
			$args['consumer_key'],   		// Consumer key
			$args['consumer_secret'],   	// Consumer secret
			$args['access_token'],   		// Access token
			$args['accesstoken_secret']	// Access token secret
		);

		$fetchedTweets = $connection->get(
			'statuses/user_timeline',
			array(
				'screen_name'    => $args['name'],
				'count'          => $args['num_tweets'],
				'exclude_replies' =>  ( isset( $args['exclude_replies'] ) ) ? $args['exclude_replies'] : ''
			)
		);

		$limitToDisplay = min( $args['num_tweets'], count( $fetchedTweets ) );
		
		if( $connection->http_code == 200 ) {
			for( $i = 0; $i < $limitToDisplay; $i++ ) {
				$tweet = $fetchedTweets[$i];

				// Core info.
				$name = $tweet->user->name;

				// COMMUNITY REQUEST !!!!!! (2)
				$screen_name = $tweet->user->screen_name;

				$permalink = 'http://twitter.com/'. $screen_name .'/status/'. $tweet->id_str;
				$tweet_id = $tweet->id_str;

				//  Check for SSL via protocol https then display relevant image - thanks SO - this should do
				if ( isset( $_SERVER['HTTPS'] ) && ( $_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1 ) || isset( $_SERVER['HTTP_X_FORWARDED_PROTO'] ) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https' ) {
					$image = $tweet->user->profile_image_url_https;
				}else {
					$image = $tweet->user->profile_image_url;
				}

				// Process Tweets - Use Twitter entities for correct URL, hash and mentions
				$text = woodmart_twitter_process_links( $tweet );

				// lets strip 4-byte emojis
				$text = preg_replace( '/[\xF0-\xF7][\x80-\xBF]{3}/', '', $text );

				// Need to get time in Unix format.
				$time = $tweet->created_at;
				$time = date_parse( $time );
				$uTime = mktime( $time['hour'], $time['minute'], $time['second'], $time['month'], $time['day'], $time['year'] );

				// Now make the new array.
				$tweets[] = array(
					'text' => $text,
					'name' => $name,
					'permalink' => $permalink,
					'image' => $image,
					'time' => $uTime,
					'tweet_id' => $tweet_id
					);
			
			}
		}

		// Now display the tweets, if we can.
		if( isset( $tweets ) ) { ?>
			<ul <?php echo ( isset( $args['show_avatar'] ) ) ? ' class="twitter-avatar-enabled"':""; ?>>
			<?php foreach( $tweets as $t ) { ?>
				<li class="twitter-post">
					<?php if ( isset( $args['show_avatar'] ) ): ?>
						<div class="twitter-image-wrapper">
							<img <?php echo ( isset( $args['avatar_size'] ) ) ? 'width="' . $args['avatar_size'] . 'px" height="' . $args['avatar_size'] . 'px"' : 'width="48px" height="48px"'; ?> src="<?php echo esc_url( $t['image'] ); ?>" alt="<?php esc_html_e( 'Tweet Avatar', 'woodmart' ); ?>">
						</div>
					<?php endif ?>
					<div class="twitter-content-wrapper">
						<?php echo wp_kses( $t['text'], array( 'a' => array('href' => true,'target' => true,'rel' => true) ) ); ?>
						<span class="stt-em">
							<a href="<?php echo esc_url( $t['permalink'] ); ?>" target="_blank">
								<?php
									$timeDisplay = human_time_diff( $t['time'], current_time('timestamp') );
									$displayAgo = _x( ' ago', 'leading space is required to keep gap from date', 'woodmart' );
									// Use to make il8n compliant
									printf( esc_html__( '%1$s%2$s', 'woodmart' ), $timeDisplay, $displayAgo );
								?>
							</a>
						</span>
					</div>
				</li>
				<?php 
			}
			?>
			</ul>
			<?php
		}
	}
}

if( ! function_exists( 'woodmart_header_block_full_screen_menu_icon' ) ) {
	function woodmart_header_block_full_screen_menu_icon() {
		if( ! woodmart_get_opt( 'full_screen_menu' ) ) return;
		?>
			<div class="woodmart-burger-icon full-screen-burger-icon">
				<span class="woodmart-burger"></span>
				<span class="woodmart-burger-label"><?php esc_html_e('Menu', 'woodmart'); ?></span>
			</div>
		<?php
	}
}
if( ! function_exists( 'woodmart_full_screen_main_nav' ) ) {
	function woodmart_full_screen_main_nav() {
		if( !woodmart_get_opt( 'full_screen_menu' ) ) return;

		$location = apply_filters( 'woodmart_main_menu_location', 'main-menu' );
		$classes = 'full-screen-nav';
		$sidebar_name = 'sidebar-full-screen-menu';
		?>
			<div class="full-screen-wrapper">
				<div class="full-screen-close-icon"></div>

				<?php woodmart_get_main_nav( $classes, $location ); ?>

				<?php if ( is_active_sidebar( $sidebar_name ) ): ?>
					<div class="widget-area-fs-menu color-scheme-light">
						<?php dynamic_sidebar( $sidebar_name ); ?>
					</div>
				<?php endif ?>
			</div>
		<?php
	}
}

if( ! function_exists( 'woodmart_get_main_nav' ) ) {
	function woodmart_get_main_nav( $classes, $location ) {
		?>
		<div class="site-navigation woodmart-navigation <?php echo esc_attr( $classes ); ?>" role="navigation">
			<?php 
				if( has_nav_menu( $location ) ) {
					wp_nav_menu(
						array(
							'theme_location' => $location,
							'menu_class' => 'menu',
							'walker' => new WOODMART_Mega_Menu_Walker()
						)
					); 
				} else {
					$menu_link = get_admin_url( null, 'nav-menus.php' );
					?>
						<span class="create-nav-msg">
						<?php 
							printf( 
								wp_kses( __('Create your first <a href="%s"><strong>navigation menu here</strong></a>', 'woodmart')
									, array(
										'a' => array(
											'href' => array()
										)
									)
								)	
							, $menu_link);
						?>
						</span>
					<?php
				}
			 ?>
		</div><!--END MAIN-NAV-->
		<?php
	}
}

if( ! function_exists( 'woodmart_get_sticky_social' ) ) {
	function woodmart_get_sticky_social() {
		if ( !woodmart_get_opt( 'sticky_social' ) ) return;
		$classes = 'woodmart-sticky-social';
		$classes .= ' woodmart-sticky-social-' . woodmart_get_opt( 'sticky_social_position' );
		$atts = array(
			'type' => woodmart_get_opt( 'sticky_social_type' ),
			'el_class' => $classes,
			'style' => 'colored',
			'size' => 'custom',
			'form' => 'square'
		);
		
		echo woodmart_shortcode_social( $atts );
	}
	add_action( 'woodmart_after_footer', 'woodmart_get_sticky_social', 200);
}